' @example testapp.vb
'
' @brief
' This is a test application illustrating how to 
' integrate LIMAN SDK to your software to protect 
' it with license keys you generate with 'limgen'
' Or a derivative of it.
'
' It Is also illustrated how license-features can
' be used to let you impose license-based restrictions
' on certain capabilities of your software. 
'
Imports System
Imports System.Text
Imports LimanSDK.NET

Public Module testapp

    Dim szLicFile, szProduct As String

    '! [Sort Functions]

    Function Quick_Sort(pLic As SWIGTYPE_p_LIMLIC, array As Integer()) as Integer

        If 0 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_0) Then

			' feature is not available
			Console.WriteLine("Quick_Sort is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'INSERT the code to perform the sort
		Console.WriteLine("Quick_Sort is allowed with existing license")


        Return 0


    End Function

    Function Merge_Sort(pLic As SWIGTYPE_p_LIMLIC, array As Integer())  as Integer

        If 0 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_1) Then

			' feature is not available
			Console.WriteLine("Merge_Sort is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'INSERT the code to perform the sort
		Console.WriteLine("Merge_Sort is allowed with existing license")


        Return 0


    End Function

    Function Heap_Sort(pLic As SWIGTYPE_p_LIMLIC, array As Integer())  as Integer

        If 0 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_2) Then

			' feature is not available
			Console.WriteLine("Heap_Sort is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'INSERT the code to perform the sort
		Console.WriteLine("Heap_Sort is allowed with existing license")

        Return 0


    End Function

    Function Insertion_Sort(pLic As SWIGTYPE_p_LIMLIC, array As Integer())  as Integer

        If 0 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_3) Then

			' feature is not available
			Console.WriteLine("Insertion_Sort is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'INSERT the code to perform the sort
		Console.WriteLine("Insertion_Sort is allowed with existing license")
		
        Return 0


    End Function

    Function Intro_Sort(pLic As SWIGTYPE_p_LIMLIC, array As Integer())  as Integer

        If 0 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_4) Then

			' feature is not available
			Console.WriteLine("Intro_Sort is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'INSERT the code to perform the sort
		Console.WriteLine("Intro_Sort is allowed with existing license")

        Return 0


    End Function

    Function Block_Sort(pLic As SWIGTYPE_p_LIMLIC, array As Integer())  as Integer

        If 0 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_5) Then

			' feature is not available
			Console.WriteLine("Block_Sort is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'INSERT the code to perform the sort
		Console.WriteLine("Block_Sort is allowed with existing license")

        Return 0


    End Function

    Function Shell_Sort(pLic As SWIGTYPE_p_LIMLIC, array As Integer())  as Integer

        If 0 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_6) Then

			' feature is not available
			Console.WriteLine("Shell_Sort is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'INSERT the code to perform the sort
		Console.WriteLine("Shell_Sort is allowed with existing license")

        Return 0


    End Function

    Function Bubble_Sort(pLic As SWIGTYPE_p_LIMLIC, array As Integer())  as Integer

        If 0 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_7) Then

			' feature is not available
			Console.WriteLine("Bubble_Sort is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'INSERT the code to perform the sort
		Console.WriteLine("Bubble_Sort is allowed with existing license")

        Return 0


    End Function

    '! [Sort Functions]
    'Run application function 0
    '
    'which requires the license to have features 1 and 2

    Function app_function0(pLic As SWIGTYPE_p_LIMLIC)  as Integer

        ' this function requires feature[1] 1st and 2nd bits turned on
        If 0 = liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_0) Or 0 = liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_1) Then

            'license does not support
            Console.WriteLine("app_function0 is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'proceed with feature

        Console.WriteLine("app_function0 is allowed with existing license")

        'INSERT FUNCTION-2 CODE

        Return 0

    End Function

    ' Run application function 1
    '
    ' which requires the license to have features 1

    Function app_function1(pLic As SWIGTYPE_p_LIMLIC)  as Integer

        'this function requires feature[1] 1st bit turned on
        If 0 = liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_0) Then

            'license does not support
            Console.WriteLine("app_function1 is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'proceed with feature

        Console.WriteLine("app_function1 is allowed with existing license")

        'INSERT FUNCTION-1 CODE

        Return 0

    End Function

    ' Run application function 2
    '
    ' which requires the license to have features 1 and 16

    Function app_function2(pLic As SWIGTYPE_p_LIMLIC)  as Integer

        ' this function requires feature[1] 1st and 5th bits turned on
        If 0 = liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_0) Or 0 = liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_4) Then

            'license does not support
            Console.WriteLine("app_function2 is not allowed with existing license")
            Return liman.LIMERR_NOT_SUPPORTED

        End If

        'proceed with feature

        Console.WriteLine("app_function2 is allowed with existing license")

        'INSERT FUNCTION-2 CODE 

        Return 0

    End Function



    Sub Main(args As String())

        If args.Length < 2 Then

            Console.WriteLine("Usage: testapp [product_id] [license_file]")

            Return

        End If

        
        Dim sBuffer As New StringBuilder("",1024)
        liman.lim_get_verstr(sBuffer)
        Console.WriteLine()
        Console.WriteLine("Version: " + sBuffer.ToString())
		
        szProduct = args(0)

        szLicFile = args(1)

        testapp_run()

    End Sub



    Public Sub onError(pEnv As SWIGTYPE_p_LIMENV, pnErr As Integer())

        Dim sbuf As New StringBuilder(255)

        If pnErr(0) <> liman.LIM_OK Then

            sbuf.Length = 0

            liman.lim_get_errmsg(pEnv, pnErr(0), sbuf)

            Console.WriteLine("Error " + CStr(pnErr(0)) + ": " + sbuf.ToString())

        End If


    End Sub

    ' Entry point

    Public Sub testapp_run()

        Dim pEnv As SWIGTYPE_p_LIMENV

        Dim pLic As SWIGTYPE_p_LIMLIC

        Dim pnErr(1) as Integer

        Dim keyLen(1) as Integer

        pnErr(0) = liman.LIM_OK      

        Console.WriteLine("Application is using license file '{0}'", szLicFile)

        ' get license 

        pEnv = liman.lim_create_env(2048, 256, pnErr(0))

        If pnErr(0) <> liman.LIM_OK Then

            onError(pEnv, pnErr)

        End If

        If 2 > 1 Then
			' Public key is hardwired into the app (recommended)
            Dim szPubKey As String
            szPubKey = "F4FFF999C2D782A1B73BDDF48187A70B6C2418C20B02A8BD862A490DE798D7C20556976550C47C45D9650E312308CED84CAC22691B4AD0C77775524D98E81D46578C9228F2CCB3C8F78AFBDA68D598031DA7FEBC46DF4D8CA43F3A4DAF0BC65AB14D87BC113291BB6F786D35A713EFF2B4014DFD6CAFFE9BBEBEA328CEC71BE15230AC41845B52A332CC1248B63C26F38B6CEE6C28904EA845A85A61F7EBA29E71C1499DBD2B272A5A5334BD29D97AB91490C8A3D2BC4B35738DF8AB1840DEB8106422968995735379AD46DB9EBD4E421114FD272075696831BB87E2822159AD0633A8F4299B9EAE92F381784F409C46E08C5C5856AA17D831825C25C70A98E3"

            pnErr(0) = liman.lim_load_public_key(pEnv, szPubKey)

            If pnErr(0) <> liman.LIM_OK Then
                onError(pEnv, pnErr)
            End If

            Console.WriteLine("Load public key.. ok.")

        Else
			' Public key lives outside the app and is read from an external file (not recommended)			
			Dim szPublicKeyFile as String
            Console.WriteLine("Reading public key..")
			szPublicKeyFile = "../keys/" + szProduct + "/" + szProduct + "_public.key"
            pnErr(0) = liman.lim_read_public_key(pEnv, szPublicKeyFile)

            If pnErr(0) <> liman.LIM_OK Then

                onError(pEnv, pnErr)

            End If

            Console.WriteLine("ok.")

        End If

        If pnErr(0) <> liman.LIM_OK Then

            onError(pEnv, pnErr)

        End If

        pLic = liman.lim_create_lic_fromfile(pEnv, szLicFile, pnErr(0))

        If pnErr(0) <> liman.LIM_OK Then

            onError(pEnv, pnErr)

        End If

        Console.WriteLine("Application License id: '{0}'", liman.lim_lic_id(pLic))

        pnErr(0) = liman.lim_is_verified(pLic)

        If pnErr(0) <> liman.LIM_OK Then

            onError(pEnv, pnErr)

        End If

        If pnErr(0) <> liman.LIM_OK Then

            Console.WriteLine("Warning: License is not verified")

            onError(pEnv, pnErr)

        Else

            Console.WriteLine("Application License is verified!")

        End If

        Dim product_id = New String(szProduct)

        If product_id.Equals(liman.lim_product_id(pLic)) = False Then

            pnErr(0) = liman.LIMERR_INVALID_PRODUCT_CODE

            onError(pEnv, pnErr)

        End If

        If liman.lim_size_id(pLic) = liman.LIMSIZE_DEMO Then

            Console.WriteLine("Application is using demo license.")

            onError(pEnv, pnErr)

        End If

        Console.WriteLine("Application License version is {0}.{1}.", liman.lim_major_version(pLic), liman.lim_minor_version(pLic))

        ' display license size and impose limitations accordingly

        If liman.lim_platform_id(pLic) <> liman.LIMPLAT_WIN32X86 Then

            pnErr(0) = liman.LIMERR_INVALID_PLATFORM

            onError(pEnv, pnErr)

        Else

            Console.WriteLine("Application License is valid for platform-id {0}.", liman.lim_platform_id(pLic))

        End If

        ' display license size and impose limitations accordingly

        Console.WriteLine("Application License type is {0}.", liman.lim_type_id(pLic))

        If liman.lim_type_id(pLic) = liman.LIMTYPE_EDUCATIONAL Then

            ' INSERT CODE

        End If

        'display license size and impose limitations accordingly

        Console.WriteLine("Application License size is {0}.", liman.lim_size_id(pLic))

        If liman.lim_size_id(pLic) = liman.LIMSIZE_DEMO Then

            ' INSERT CODE

        End If

        '! [Availability of Sort Functions]
        ' Check bitmask in slot 0

        If 1 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_0) Then

            Console.WriteLine("Quick Sort Feature is available")

        End If

        If 1 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_1) Then

            Console.WriteLine("Merge Sort Feature is available")

        End If

        If 1 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_2) Then

            Console.WriteLine("Heap Sort Feature is available")

        End If

        If 1 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_3) Then

            Console.WriteLine("Insertion Sort Feature is available")

        End If

        If 1 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_4) Then

            Console.WriteLine("Intro Sort Feature is available")

        End If

        If 1 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_5) Then

            Console.WriteLine("Block Sort Feature is available")

        End If

        If 1 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_6) Then

            Console.WriteLine("Shell Sort Feature is available")

        End If

        If 1 = liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_7) Then

            Console.WriteLine("Bubble Sort Feature is available")

        End If

        '! [Availability of Sort Functions]

        '1'st slot specifies which functions are avaiable under given license key

        'run function 0
        pnErr(0) = app_function0(pLic)
        If pnErr(0) <> liman.LIM_OK Then
            onError(pEnv, pnErr)
        End If        

        'run function 1
        pnErr(0) = app_function1(pLic)
        If pnErr(0) <> liman.LIM_OK Then
            onError(pEnv, pnErr)
        End If        

        'run function 2
        pnErr(0) = app_function2(pLic)
        If pnErr(0) <> liman.LIM_OK Then
            onError(pEnv, pnErr)
        End If

        liman.lim_delete_lic(pLic)

        liman.lim_delete_env(pEnv)

        Return

    End Sub

End Module


