/** \example testapp.c
 * \brief
 * This is a test application illustrating how to
 * integrate LIMAN SDK to your software to protect
 * it with license keys you generate with 'limgen'
 * or a derivative of it.
 *
 * It is also illustrated how license-features can
 * be used to let you impose license-based restrictions
 * on certain capabilities of your software.
 */
/*
   Application: TESTAPP
   Purpose:     Dummy sort routines and dummy features.
   Remark:      Using LIMAN SDK for license protection.
*/
#include "liman.h"

//! [Sort Functions]
int Quick_Sort(pLIMLIC pLic, int *array) {

  if (!lim_has_feature(pLic,0,LIMOPT_FEATURE_0)) {
     return LIMERR_NOT_SUPPORTED; // feature is not available
  }
  /* INSERT the code to perform the sort */
  return 0;
}

int Merge_Sort(pLIMLIC pLic, int *array) {

  if (!lim_has_feature(pLic,0,LIMOPT_FEATURE_1)) {
     return LIMERR_NOT_SUPPORTED; // feature is not available
  }
  /* INSERT the code to perform the sort */
  return 0;
}

int Heap_Sort(pLIMLIC pLic, int *array) {

  if (!lim_has_feature(pLic,0,LIMOPT_FEATURE_2)) {
     return LIMERR_NOT_SUPPORTED; // feature is not available
  }
  /* INSERT the code to perform the sort */
  return 0;
}

int Insertion_Sort(pLIMLIC pLic, int *array) {

  if (!lim_has_feature(pLic,0,LIMOPT_FEATURE_3)) {
     return LIMERR_NOT_SUPPORTED; // feature is not available
  }
  /* INSERT the code to perform the sort */
  return 0;
}

int Intro_Sort(pLIMLIC pLic, int *array) {

  if (!lim_has_feature(pLic,0,LIMOPT_FEATURE_4)) {
     return LIMERR_NOT_SUPPORTED; // feature is not available
  }
  /* INSERT the code to perform the sort */
  return 0;
}

int Block_Sort(pLIMLIC pLic, int *array) {

  if (!lim_has_feature(pLic,0,LIMOPT_FEATURE_5)) {
     return LIMERR_NOT_SUPPORTED; // feature is not available
  }
  /* INSERT the code to perform the sort */
  return 0;
}

int Shell_Sort(pLIMLIC pLic, int *array) {

  if (!lim_has_feature(pLic,0,LIMOPT_FEATURE_6)) {
     return LIMERR_NOT_SUPPORTED; // feature is not available
  }
  /* INSERT the code to perform the sort */
  return 0;
}

int Bubble_Sort(pLIMLIC pLic, int *array) {

  if (!lim_has_feature(pLic,0,LIMOPT_FEATURE_7)) {
     return LIMERR_NOT_SUPPORTED; // feature is not available
  }
  /* INSERT the code to perform the sort */
  return 0;
}
//! [Sort Functions]

/*
 *  Run application function 0
 *  which requires the license to have features 1 and 2
 **/
int app_function0(pLIMLIC pLic) {

  // this function requires feature[1] 1st and 2nd bits turned on
  if (!lim_has_feature(pLic,1,LIMOPT_FEATURE_0) || !lim_has_feature(pLic,1,LIMOPT_FEATURE_1)) {
    //license does not support
    fprintf(stdout,"app_function0 is not allowed with existing license\n");
    return LIMERR_NOT_SUPPORTED;
  }
  //proceed with feature
  fprintf(stdout,"app_function0 is allowed with existing license\n");

  /* INSERT FUNCTION-2 CODE */

  return 0;
}


/*
 *  Run application function 1
 *  which requires the license to have features 1
 **/
int app_function1(pLIMLIC pLic) {

  // this function requires feature[1] 1st bit turned on
  if (!lim_has_feature(pLic,1,LIMOPT_FEATURE_0)) {
    //license does not support
    fprintf(stdout,"app_function1 is not allowed with existing license\n");
    return LIMERR_NOT_SUPPORTED;
  }
  //proceed with feature
  fprintf(stdout,"app_function1 is allowed with existing license\n");

  /* INSERT FUNCTION-1 CODE */

  return 0;
}


/*
 *  Run application function 2
 *  which requires the license to have features 1 and 16
 **/
int app_function2(pLIMLIC pLic) {

  // this function requires feature[1] 1st and 5th bits turned on
  if (!lim_has_feature(pLic,1,LIMOPT_FEATURE_0) || !lim_has_feature(pLic,1,LIMOPT_FEATURE_4)) {
    //license does not support
    fprintf(stdout,"app_function2 is not allowed with existing license\n");
    return LIMERR_NOT_SUPPORTED;
  }
  //proceed with feature
  fprintf(stdout,"app_function2 is allowed with existing license\n");

  /* INSERT FUNCTION-2 CODE */

  return 0;
}

const char* lim_usr_public_key_n(int *nLength);
/*
 * Entry point
 */
int main(int argc, char **argv)
{
  pLIMENV pEnv;
  pLIMLIC pLic;

  int nErr=LIM_OK, ibuf;
  const char *szPubKey="F4FFF999C2D782A1B73BDDF48187A70B6C2418C20B02A8BD862A490DE"
  					   "798D7C20556976550C47C45D9650E312308CED84CAC22691B4AD0C777"
  					   "75524D98E81D46578C9228F2CCB3C8F78AFBDA68D598031DA7FEBC46D"
  					   "F4D8CA43F3A4DAF0BC65AB14D87BC113291BB6F786D35A713EFF2B401"
  					   "4DFD6CAFFE9BBEBEA328CEC71BE15230AC41845B52A332CC1248B63C2"
  					   "6F38B6CEE6C28904EA845A85A61F7EBA29E71C1499DBD2B272A5A5334"
  					   "BD29D97AB91490C8A3D2BC4B35738DF8AB1840DEB8106422968995735"
  					   "379AD46DB9EBD4E421114FD272075696831BB87E2822159AD0633A8F4"
  					   "299B9EAE92F381784F409C46E08C5C5856AA17D831825C25C70A98E3";
  const char *szLicFile=NULL; //license key file

  char szVerInfo[256];

  lim_get_version_info(szVerInfo);
  fprintf(stdout,"LIMAN SDK Version: %s\n", szVerInfo);

  if (argc<2) {
    fprintf(stdout,"Usage: testapp [license_file] \n");
    exit(0);
  }
  szLicFile=argv[1];
  fprintf(stdout,"Application is using license file '%s'\n",szLicFile);

  /* get license */
  pEnv = lim_create_env(2048,256,&nErr);
  if (nErr) goto ErrReturn;

#if 0
  // use local hardcoded copy of public key
  nErr = lim_load_public_key(pEnv,(char*)szPubKey);
#else
  // use public key hardcoded in libliman_TESTAPP_sdk.lib
  nErr = lim_load_public_key(pEnv,lim_usr_public_key_n(&ibuf));
#endif

  if (nErr) goto ErrReturn;

  pLic = lim_create_lic_fromfile(pEnv,szLicFile,&nErr);
  if (nErr) goto ErrReturn;
  fprintf(stdout,"License id: '%s'\n",lim_lic_id(pLic));

  nErr = lim_is_verified(pLic);
  if (nErr) goto ErrReturn;

  fprintf(stdout,"License is verified!\n");

  if (nErr) {
    fprintf(stdout,"Application failed to continue\n");
    fprintf(stdout,"DEBUG: LIMAN SDK returned error %d\n",nErr);
    fprintf(stdout,"DEBUG: LIMAN SDK error message: %s\n",lim_errmsg(NULL,nErr));
    goto ErrReturn;
  }

  if (strcmp(lim_product_id(pLic),"TESTAPP")) {
    nErr = LIMERR_INVALID_PRODUCT_CODE;
    goto ErrReturn;
  }

  if (lim_size_id(pLic)==LIMSIZE_DEMO) {
    fprintf(stdout,"Application is using demo license.\n");
    goto ErrReturn;
  }

  fprintf(stdout,"Application version is %d.%d.\n",lim_major_version(pLic),lim_minor_version(pLic));

  // display license size and impose limitations accordingly
  fprintf(stdout,"License is valid for platform-id %d.\n",lim_platform_id(pLic));
  if (lim_platform_id(pLic)!=LIMPLAT_WIN32X86) {
    nErr = LIMERR_INVALID_PLATFORM;
    goto ErrReturn;
  }

  // display license size and impose limitations accordingly
  fprintf(stdout,"Application License type is %d.\n",lim_type_id(pLic));
  if (lim_type_id(pLic)==LIMTYPE_EDUCATIONAL) {
    // INSERT CODE
  }

  // display license size and impose limitations accordingly
  fprintf(stdout,"Application license size is %d.\n",lim_size_id(pLic));
  if (lim_size_id(pLic)==LIMSIZE_DEMO) {
    // INSERT CODE
  }

  // 0'th slot specifies which sorting methods are available under given license key
  {
    //! [Availability of Sort Functions]
    // Check bitmask in slot 0
    if (lim_has_feature(pLic,0,LIMOPT_FEATURE_0)) {
      printf("Quick Sort Feature is available\n");
    }
    if (lim_has_feature(pLic,0,LIMOPT_FEATURE_1)) {
      printf("Merge Sort Feature is available\n");
    }
    if (lim_has_feature(pLic,0,LIMOPT_FEATURE_2)) {
      printf("Heap Sort Feature is available\n");
    }
    if (lim_has_feature(pLic,0,LIMOPT_FEATURE_3)) {
      printf("Insertion Sort Feature is available\n");
    }
    if (lim_has_feature(pLic,0,LIMOPT_FEATURE_4)) {
      printf("Intro Sort Feature is available\n");
    }
    if (lim_has_feature(pLic,0,LIMOPT_FEATURE_5)) {
      printf("Block Sort Feature is available\n");
    }
    if (lim_has_feature(pLic,0,LIMOPT_FEATURE_6)) {
      printf("Shell Sort Feature is available\n");
    }
    if (lim_has_feature(pLic,0,LIMOPT_FEATURE_7)) {
      printf("Bubble Sort Feature is available\n");
    }
    //! [Availability of Sort Functions]
  }

  // 1'st slot specifies which functions are avaiable under given license key
  {
    // run function 0
    if (app_function0(pLic)!=0) {
      printf("app_function0 was not executed due to license capacity/restrictions\n");
    }

    // run function 1
    if (app_function1(pLic)!=0) {
      printf("app_function1 was not executed due to license capacity/restrictions\n");
    }

    // run function 2
    if (app_function2(pLic)!=0) {
      printf("app_function2 was not executed due to license capacity/restrictions\n");
    }
  }



ErrReturn:
  if (nErr) {
    fprintf(stdout,"Error %d: %s \n",nErr,lim_errmsg(pEnv,nErr));
  }
  lim_free_lic(&pLic);
  lim_free_env(&pEnv);
  return nErr;
}

