#!/bin/sh
# Generate a new license for LIMAN SDK using its designated key-pair
# (c) Baroks Inc.
# $Id$
#
LIMAN_ROOT=../..
PWD=`pwd`
PLATFORM=${PWD##*/}

# Check if LIMAN_ROOT is set correctly
if [ ! -f "$LIMAN_ROOT/bin/lic_info.sh" ]; then
    echo "Error: LIMAN_ROOT not set correctly. Run from lib/<platform>/ directory or source limsetenv.sh in level 1"
    echo "Current LIMAN_ROOT: $LIMAN_ROOT"
    exit 1
fi

echo Platform: $PLATFORM

PRODUCT=$1
if [ "$PRODUCT" = "" ]; then
	echo "Usage: lg_library.sh PRODUCTID [limgen-options]"
	exit 1
fi
shift 1
LIMGEN=$LIMAN_ROOT/lib/${PLATFORM}/limgen

#Location of public key (modify if needed)
PUB=$LIMAN_ROOT/lib/${PLATFORM}/${PRODUCT}/lib_public.key

#Location of private key (modify if needed)
PRIV=$LIMAN_ROOT/lib/${PLATFORM}/${PRODUCT}/lib_private.key

#Generate a product key with specified input
#Type limgen -h for help
echo Product: $PRODUCT
echo Private key file: $PRIV
echo Public key file: $PUB
$LIMGEN --product=$PRODUCT --privkeyfile=$PRIV  --pubkeyfile=$PUB --major=1 --minor=3 --features=15,3,3,5 $1 $2 $3 $4 $5 $6 $7 $8 $9
