#!/bin/sh
#
# Detect platform (included from lg_*.sh)
# 
# Baroks Inc.

UNAME_S=`uname -s`
UNAME_O=`uname -o`
UNAME_M=`uname -m`
echo $UNAME_S, $UNAME_O, $UNAME_M
if [ "$UNAME_S" = "Linux" ]; then
	PLATFORM=linux
elif [ "$UNAME_S" = "Darwin" ]; then
	PLATFORM=osx
elif [ "$UNAME_O" = "Cygwin" ]; then
	PLATFORM=cyg
fi

if [ "$UNAME_M" = "x86_64" ]; then
	PLATFORM=${PLATFORM}64x86	
elif [ "$UNAME_M" = "x86" ]; then
	PLATFORM=${PLATFORM}32x86
else
	PLATFORM=$UNAME_M
fi
export PLATFORM
echo $PLATFORM