@echo off&setlocal
rem cmd
rem Generate a new license for the specified product using its designated key-pair
rem (c) Baroks Inc.
rem $Id$
rem
if "%LIMAN_ROOT%"=="" goto no_liman_root

rem get PLATFORM from directory
for %%a in (.) do set PLATFORM=%%~na
@echo Platform: %PLATFORM%

set PRODUCT=%1
shift 1
if "%PRODUCT%" == "" goto usage
set LIMGEN=%LIMAN_ROOT%\lib\%PLATFORM%\limgen

if not exist %LIMAN_ROOT%\lib\%PLATFORM% goto :noproduct

rem Location of public key (modify if needed)
set PUB=%LIMAN_ROOT%\lib\%PLATFORM%\%PRODUCT%\%PRODUCT%_public.key

rem Location of private key (modify if needed)
set PRIV=%LIMAN_ROOT%\lib\%PLATFORM%\%PRODUCT%\%PRODUCT%_private.key

rem Generate a product key with specified input
rem Type limgen -h for help
@echo Product: %PRODUCT%
@echo Private key file: %PUB%
@echo Public key file: %PRIV%

if not exist %PUB% goto :nopubkeyfile
if not exist %PRIV% goto :noprivkeyfile

%LIMGEN% --product=%PRODUCT% --privkeyfile=%PRIV%  --pubkeyfile=%PUB% %*
@echo.
@echo Check command to generate the license:
@echo %LIMGEN% --product=%PRODUCT% --privkeyfile=%PRIV%  --pubkeyfile=%PUB% %*
goto end

:noproduct
@echo.
@echo Error: %LIMAN_ROOT%\lib\%PLATFORM% folder does not exist
goto end

:nopubkeyfile
@echo.
@echo Error: %PUB% file does not exist
goto end

:noprivkeyfile
@echo.
@echo Error: %PRIV% file does not exist
goto end

:no_liman_root
@echo.
@echo LIMAN_ROOT variable is not defined
goto end

:usage
@echo Usage: lg_product PRODUCT-ID [limgen-options]
goto end
:noplatform
@echo Variable 'PLATFORM' not set. Type 'set PLATFORM=<platform>' and re-run
goto end


:end